//
//  Adding_Recurring_Events_to_CalendarsAppDelegate.m
//  Adding Recurring Events to Calendars
//
//  Created by Vandad Nahavandipoor on 24/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Adding_Recurring_Events_to_CalendarsAppDelegate.h"

@implementation Adding_Recurring_Events_to_CalendarsAppDelegate

@synthesize window = _window;

- (void) createRecurringEventInLocalCalendar{
  
  /* Krok 1: Inicjalizacja obiektu bazy danych kalendarzy. */
  EKEventStore *eventStore = [[EKEventStore alloc] init];
  
  /* Krok 2: Odszukanie pierwszego lokalnego kalendarza, który można modyfikować. */
  EKCalendar *targetCalendar = nil;
  
  for (EKCalendar *thisCalendar in eventStore.calendars){
    if (thisCalendar.type == EKCalendarTypeLocal &&
        [thisCalendar allowsContentModifications]){
      targetCalendar = thisCalendar;
    }
  }
  
  /* Czy kalendarz docelowy nie został znaleziony? */
  if (targetCalendar == nil){
    NSLog(@"Kalendarz docelowy nie został znaleziony.");
    return;
  }
  
  /* Krok 3: Utworzenie wydarzenia. */
  EKEvent *event = [EKEvent eventWithEventStore:eventStore];
  
  /* Krok 4.: Utworzenie wydarzenia, które występuje dzisiaj oraz
   tego samego dnia w każdym miesiącu przez okres roku. */
  
  NSDate *eventStartDate = [NSDate date];
  
  /* Krok 5.: Wydarzenie trwa dokładnie godzinę. */
  NSTimeInterval NSOneHour = 1 * 60 * 60;
  NSDate *eventEndDate = [eventStartDate dateByAddingTimeInterval:NSOneHour];
  
  /* Przypisanie wymaganych parametrów, zwłaszcza kalendarza docelowego. */
  event.calendar = targetCalendar;
  event.title = @"Moje wydarzenie";
  event.startDate = eventStartDate;
  event.endDate = eventEndDate;
  
  /* Powtarzanie wydarzenia kończy się dokładnie za rok. */
  NSTimeInterval NSOneYear = 365 * 24 * 60 * 60;
  NSDate *oneYearFromNow = [eventStartDate dateByAddingTimeInterval:NSOneYear];
  
  /* Krok 6.: Utworzenie daty Event Kit na podstawie podanej. */
  EKRecurrenceEnd *recurringEnd =
  [EKRecurrenceEnd recurrenceEndWithEndDate:oneYearFromNow];
  
  /* Krok 7.: Dodanie reguł powtarzania się wydarzenia. To wydarzenie będzie powtarzane
   co miesiąc (EKRecurrenceFrequencyMonthly), jednokrotnie (interval:1),
   a powtarzanie wydarzenia kończy się dokładnie za rok (end:RecurringEnd). */
  
  EKRecurrenceRule *recurringRule =
  [[EKRecurrenceRule alloc]
   initRecurrenceWithFrequency:EKRecurrenceFrequencyMonthly
   interval:1
   end:recurringEnd];
  
  /* Krok 8.: Przypisanie wydarzeniu reguły jego powtarzania się. */
  event.recurrenceRules = [[NSArray alloc] initWithObjects:recurringRule, nil];
  
  NSError *saveError = nil;
  
  /* Krok 9.: Zapisanie wydarzenia. */
  if ([eventStore saveEvent:event
                       span:EKSpanFutureEvents
                      error:&saveError]){
    NSLog(@"Z powodzeniem zapisano powtarzające się wydarzenie.");
  } else {
    NSLog(@"Nie udało się utworzyć powtarzającego się wydarzenia %@", saveError);
  }
  
}

- (BOOL)            application:(UIApplication *)application
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  [self createRecurringEventInLocalCalendar];
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
